/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  double precision pwm.c
*  :  LuF
*  :  V1.0
*  :  2018/7/24
*  :  ˫PWM
          1:ʹоƬ˫PWMģʽPB0˿ڼPB1˿ʵΪ100us~50usռձȷֱΪ25%50%ķ
            ڷĴεݼ50usٽװΪ100usռձȲ䣬Դη
          2.оƬʹ16MHzϵͳʱӣӦT11ʱʱԴΪ1/16MHzT20ԤƵã11T11
            ĴT11Pʼֵ㹫ʽӦΪ
            PWM100us = T11P  1/16MHz 1ԤƵȣT11PֵPERIOD = 16000x0640
            PWM50us = T11R  1/16MHz 1ԤƵȣT11RֵDUTY11 = 8000x0320PB1˿ڵΪ
            PWMռձ50% = T11R / T11P
*  ע:  ES7P202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);

#define PERIOD 1600
#define DUTY10 400
#define DUTY11 800

unsigned int N_Period;
unsigned int N_Duty10;
unsigned int N_Duty11;

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T11PIE &&T11PIF) 
    {                                   //T11ж
        T11PIF = 0;
        if(N_Period >=1000)
        {
            N_Period -= 200;
            N_Duty10 -= 50;
            N_Duty11 -= 100;
            T11PH = N_Period>>8;
            T11PL = N_Period;           //PWM
            T11R1H = N_Duty11 >> 8;
            T11R1L = N_Duty11;          //PWM
            T11R0H = N_Duty10>> 8;
            T11R0L = N_Duty10;          //PWM 
        }
        else
        {
            N_Period = PERIOD;
            N_Duty10 = DUTY10;
            N_Duty11 = DUTY11;
            T11PH = N_Period>>8;
            T11PL = N_Period;           //PWM
            T11R1H = N_Duty11 >> 8;
            T11R1L = N_Duty11;          //PWM
            T11R0H = N_Duty10>> 8;
            T11R0L = N_Duty10;          //PWM
        }
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
    RAMClear();                 //RAM
    PBS = 0x00;                 //PBΪI/O
    PB0 = 0;                    //PB0˿͵ƽ
    PBT0= 0; 		            //PB0˿Ϊ      
    PB1 = 0;                    //PB1˿͵ƽ
    PBT1= 0; 		            //PB1˿Ϊ      
    
    N_Period = PERIOD;
    N_Duty11 = DUTY11;
    N_Duty10 = DUTY10;
    T11CL = 0xC1;		        //T11˫PWMģʽ

    T11CM = 0x00;		        //T11ԤƵƵ
    P11EN = 1;		            //PWM111PB1
    P10EN = 1;
    T11PH = N_Period >> 8;
    T11PL = N_Period;           //
    T11R1H = N_Duty11 >> 8;
    T11R1L = N_Duty11;          //þ
    T11R0H = N_Duty10 >> 8;
    T11R0L = N_Duty10;          //þ
    T11CH = 0x80;		        //ʹT11
    T11PIE = 1; 		        //ʹT11ж
    GIE = 1;		            //ʹȫж 
    while(1);
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
